const db = require('../config/db');

const Latihan = {
  // Mengambil semua latihan, misalnya berdasarkan materi_id (opsional)
  getAllByMateri: (materiId, callback) => {
    let query = 'SELECT * FROM latihan';
    let params = [];
    if (typeof materiId !== 'undefined' && materiId !== null) {
      query += ' WHERE materi_id = ?';
      params.push(materiId);
    }
    query += ' ORDER BY created_at DESC';
    db.query(query, params, callback);
  },

  // Mengambil latihan berdasarkan id
  getById: (id, callback) => {
    const query = 'SELECT * FROM latihan WHERE id = ?';
    db.query(query, [id], callback);
  }
};

module.exports = Latihan;
