const db = require('../config/db');

class Quiz {
  /**
   * Ambil semua pertanyaan berdasarkan materiId
   */
  static async getByMateriId(materiId) {
    return new Promise((resolve, reject) => {
      const query = `
        SELECT id, pertanyaan, opsi, jawaban 
        FROM quiz 
        WHERE materi_id = ?
      `;
      db.query(query, [materiId], (err, results) => {
        if (err) {
          return reject(err);
        }
        resolve(results);
      });
    });
  }
}

module.exports = Quiz;
